

%--------------------------------------------------------------------------
%     Vypocet teplotniho pole pro plynule odlevani oceli                  %
%--------------------------------------------------------------------------


% Fourier-Kirchhoffova rovnice pro problem plynuleho odlevani oceli
% Numericka metoda - diferencni metoda (metoda siti)
% Problm hledame ve tvaru PDR2:  c*rho*ut(x,y,t) = lambda*(uxx(x,y,t)+uzz(x,y,t)) + c*rho*V*uy(x,y,t)+q  
% kde u - teplota [K]
%     c - merna tepelna kapacita [J/kgK]
%     lambda - tepelna vodivost[W/mK]
%     rho - hustota [kg/m^3]
%     q - zdroj skupenskych tepel [W/m^3]
% Problem rame explicitni Eulerovou metodou 
% Sit je v ose x ekvidistantni, v ose z je tvorena podle polohy valcu


function [u] = model(t_f,T,PP,htc,speed,handles,hObject)
% ,htc1,htc2,htc3,htc4,htc5,htc6,htc7,htc8,htc9,htc10,htc11,htc12,htc13,VV
% t_f - koncov as pro vpoet , T - poet dlen na asov ose ,
% PP - 0 poten podmnka lici teplota , PP - 1 naten teplotnho pole 
% z minulho vpotu , TT - 0 vpoet s uchovvn teplotnho pole pro  
% vechny asy , TT - 1 uchov pouze posledn teplotn pole.
%--------------------------------------------------------------------------
%                  M    <-{i;j}{0;0}
%                    ----   |
%                   |    |  v
%                   |    |
%                   |    |
%                   |    |
%                    ----   N
%--------------------------------------------------------------------------
%Rozdeleni site
global M
global N
M=15;
N=187;
%--------------------------------------------------------------------------
%Tvorba matic
       h = zeros(M,N);
       u = zeros(M,N); 
      hh = zeros(M,N);
      uu = zeros(M,N);
 
   
      qq_VR = zeros(N,1);
      qq_MR = zeros(N,1);
  htc_rolvr = zeros(N,1);
  htc_rolmr = zeros(N,1);
         ry = zeros(N-1,1);
       rphi = zeros(N-1,1);
%--------------------------------------------------------------------------
%Dlen osy z ve smru tavby, naten okrajovch podmnek ze souboru
OP_MR=load('valce + trysky MR.txt');
OP_VR=load('valce + trysky VR.txt');
%--------------------------------------------------------------------------
%Vstupni parametry                              
%        rychlost liti [m/s]
%               VV = 0.8 ;   %rychlost liti [m/min] 
               VV = speed;
               V = VV/60;  %rychlost liti [m/min]

%Dosazazeni tepelnych toku do matice OP_VR a OP_MR
% htc1=2500;
% htc2=2000;
% htc3=2000;
% htc4=1700;
% htc5=1200;
% htc6=900;
% htc7=12000;
% htc8=700;
% htc9=900;
% htc10=600;
% htc11=800;
% htc12=500;
% htc13=600;
% 
% htc=[htc1,htc2,htc3,htc4,htc5,htc6,htc7,htc8,htc9,htc10,htc11,htc12,htc13];
%VR=1,3,4,5,7,9,11,13
%MR=1,3,4,5,6,8,10,12

for j=1:N
    for i=1:13
        if OP_VR(j,3)==i
            OP_VR(j,5)=htc(i);
        end
         if OP_MR(j,3)==i
            OP_MR(j,5)=htc(i);
        end
    end
end

%--------------------------------------------------------------------------
%naten entalpie
global steel
       H = enthalpy(steel);
       a = 1;
       b = max(size(H));                
%naten vodivosti
  lambda = conductivity(steel);             
%--------------------------------------------------------------------------
%Pocatecni podminka        
%       pocatecni podminka
            u0 = 1550;    %poten teplota na celm ZPO
               switch PP  
                  case 0
                 
                       u=ones(M,N)*u0;            %zmena
                       h=ones(M,N)*H(u0);         %zmena
             

                 case 1   %naten poten teploty z minulho vpotu
          
                      u(:,:)=load('ZPO2Du.dat');
                      h(:,:)=load('ZPO2Dh.dat'); 
               
               end  
%--------------------------------------------------------------------------
%Krystaliztor, teplota vody a vzduchu
        tt = 1/V;                   % cas setrvani predlitku v krystalizatoru
         D = 8;                      % konstanta krystalizatoru (mezi 7-10)
        qo = -D*tt^(-0.5)*10^6;     % mrn tepeln tok na prave a leve strane, odvod tepla krystalizatorem [W/m^2]
%       qo = -9.7980e+005;         
    
        Tw = 20;                    % teplota vody                          
      Tinf = 25;                    % teplota okol
      uvst = 1550;                  % teplota na vstupu do ZPO   
      Trol = 300;                   % teplota vlce
%Radiace - redukovany htc pro teplotu 1000 [C]          
       eps = 0.78828571429 + 0.0003375*(1000+273.15) - 40.17857143*10^(-8)*(1000+273.15)^2;
   eps_rol = 0.78828571429 + 0.0003375*(Trol+273.15) - 40.17857143*10^(-8)*(Trol+273.15)^2;
%--------------------------------------------------------------------------      
%Rozmry ZPO a rozdlen prostoru    
global L
        L = 0.25;     %  dlka osy x [m] (ky bramy)
       K1 = 0.35;     %  dlka osy z krystalizator rovna cast - hladina oceli[m]  
       K2 = 13.5 ;    %  dlka osy z VR ohyb[m]   
       K3 = 8.14 ;    %  dlka osy z rovna cast nucena konvekce[m]  
       K4 = 2.127 ;   %  dlka osy z rovna cast prirozena konvekce[m]  
        R = 8;        %  polomer ohybu VR strana[m] 

%Nastaveni prostoroveho a casoveho kroku     
       for i = 1:size(OP_VR,1)-1
           dz(i) = OP_VR(i+1,1)-OP_VR(i,1);
       end

          dx = L/(M-1);
          dr = dx;
          dz = dz'/1000;
          dt = t_f/T;               
%--------------------------------------------------------------------------

%Vykreslen grafu
global xx
global zz
global zzz
global zzzz
global zz1
global zz2
global zz3

    xx = 0:dx:L;
    zz = OP_VR(:,1)/1000;
   zzz = OP_MR(:,1)/1000; 
  zzzz = (zzz+zz)/2;
   zz1 = zz(1:10);
   zz2 = zz(10:116)-zz(10);
   zz3 = zz(116:N)-zz(116);
   
 
%--------------------------------------------------------------------------
%Vpoet

             rx = dt/dx^2;   %substituce do rovnic
             rr = dt/dr^2;
    for j = 2:N-1
          ry(j) = dt/((dz(j)+dz(j-1))/2);   %substituce do rovnic
    end
    for j = 2:N-1
        rphi(j) = dt/(((dz(j)+dz(j-1))/2)*R); %substituce do rovnic
    end


    for j=1:N      %odveden teplo na konkrtnm vlci
          if OP_VR(j,3)==0 
             htc_rolvr(j) = (OP_VR(j,5)+eps_rol*5.67051*10^(-8)*((Trol+273.15)^2+(Tinf+273.15)^2)*((Trol+273.15)+(Tinf+273.15))); 
                 qq_VR(j) = -htc_rolvr(j)*pi*0.5*(OP_VR(j,4)/1000)*(Trol-Tinf);    
          end
          if OP_MR(j,3)==0 
             htc_rolmr(j) = (OP_MR(j,5)+eps_rol*5.67051*10^(-8)*((Trol+273.15)^2+(Tinf+273.15)^2)*((Trol+273.15)+(Tinf+273.15)));
                 qq_MR(j) = -htc_rolmr(j)*pi*0.5*(OP_MR(j,4)/1000)*(Trol-Tinf);    
          end
     end
    
    
    
    
%     STRANA VSTUPU ZPO

                u(1:M,1) = ones(M,1)*uvst;    
               hh(1:M,1) = ones(M,1)*H(uvst);    
  
     for k=1:T   

%     SPODNI OKRAJE ZPO    

                       lam = lambda(round(u(1,N)));      
                   htc_nat = 0.84*(u(1,N)-Tinf)^0.5;
                     htc_r = (0.78828571429 + 0.0003375*(u(1,N)+273.15) - 40.17857143*10^(-8)*(u(1,N)+273.15)^2)*5.67051*10^(-8)*((u(1,N)+273.15)^2+(Tinf+273.15)^2)*((u(1,N)+273.15)+(Tinf+273.15));
                        QX = rx*lam*(2*(htc_nat+htc_r)*dx*(Tinf-u(1,N))/lam+u(2,N)-2*u(1,N)+u(2,N));
                        QZ = ry(N-1)*lam*((-2*0*dx+u(1,N-1)-u(1,N))/dz(N-1)+(u(1,N-1)-u(1,N))/dz(N-1));
                   hh(1,N) = h(1,N) + QX + QZ + V*dt*(h(1,N-1)-h(1,N))/dz(N-1);
                                  
                       lam = lambda(round(u(M,N))); 
                   htc_nat = 0.84*(u(M,N)-Tinf)^0.5;
                     htc_r = (0.78828571429 + 0.0003375*(u(M,N)+273.15) - 40.17857143*10^(-8)*(u(M,N)+273.15)^2)*5.67051*10^(-8)*((u(M,N)+273.15)^2+(Tinf+273.15)^2)*((u(M,N)+273.15)+(Tinf+273.15));
                        QX = rx*lam*(2*(htc_nat+htc_r)*dx*(Tinf-u(M,N))/lam+u(M-1,N)-2*u(M,N)+u(M-1,N));
                        QZ = ry(N-1)*lam*((-2*0*dx+u(M,N-1)-u(M,N))/dz(N-1)+(u(M,N-1)-u(M,N))/dz(N-1));  
                   hh(M,N) = h(M,N) + QX + QZ + V*dt*(h(M,N-1)-h(M,N))/dz(N-1);
    
          for j=2:N-1
              for i=2:M-1             
%     UVNITR ZPO    

             lam = lambda(round(u(i,j)));
                  if OP_VR(j,6)==0 
                  
                             QX = rx*lam*(u(i-1,j)-2*u(i,j)+u(i+1,j));
                             QZ = ry(j)*lam*((u(i,j-1)-u(i,j))/dz(j-1)+(u(i,j+1)-u(i,j))/dz(j));
                        hh(i,j) = h(i,j) + QX + QZ + V*dt*(h(i,j-1)-h(i,j))/dz(j-1);
 
  % % % % 
                  else
                            QR1 = dt*lam*(u(i-1,j)-u(i,j))/((R-(M-1)*dr+i*dr-dr)*dr);
                            QR2 = rr*lam*(u(i-1,j)-2*u(i,j)+u(i+1,j));
                           QPHI = rphi(j)*(R-(M-1)*dr+i*dr-dr)*lam*((u(i,j-1)-u(i,j))/(dz(j-1)*(R-(M-1)*dr+i*dr-dr)/R)+(u(i,j+1)-u(i,j))/(dz(j)*(R-(M-1)*dr+i*dr-dr)/R));
                        hh(i,j) = h(i,j) + QR1 + QR2 + QPHI + V*dt*(h(i,j-1)-h(i,j))/(dz(j-1)*(R-(M-1)*dr+i*dr-dr)/R);
  % % % % %
                  end                                                          
%     STRANA KONCE ZPO (REZANI)

                        lam = lambda(round(u(i,N)));
                         QX = rx*lam*(u(i-1,N)-2*u(i,N)+u(i+1,N));
                         QZ = ry(N-1)*lam*((-2*0*dx+u(i,N-1)-u(i,N))/dz(j-1)+(u(i,N-1)-u(i,N))/dz(j));
                    hh(i,N) = h(i,N) +  QX + QZ + V*dt*(h(i,N-1)-h(i,N))/dz(N-1);               
              end
              
%     STRANA CHLAZENI ZPO VR     
          lam = lambda(round(u(M,j)));
               if OP_VR(j,2)==1  
                   if OP_VR(j,6)==0 
                                QX = rx*lam*(2*qo/lam*dx+u(M-1,j)-2*u(M,j)+u(M-1,j));
                                QZ = ry(j)*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                           hh(M,j) = h(M,j) +  QX + QZ + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
% % % %  
                   else
                       
                               QR1 = dt*lam*(2*qo/lam*dr+u(M-1,j)-u(M-1,j))/(R*dr);
                               QR2 = rr*lam*(2*qo/lam*dr+u(M-1,j)-2*u(M,j)+u(M-1,j));
                              QPHI = rphi(j)*R*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                           hh(M,j) = h(M,j) +  QR1 + QR2 + QPHI  + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
% % % % % % 
                   end
                   
               elseif OP_VR(j,2)==2 
                      
                         if OP_VR(j,3)==0  
                              if OP_VR(j,6)==0      
                                      QX = rx*lam*(2*qq_VR(j)/lam*dx+u(M-1,j)-2*u(M,j)+u(M-1,j));
                                      QZ = ry(j)*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                                 hh(M,j) = h(M,j) +  QX + QZ  + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
                              else
% % % % % %
                                     QR1 = dt*lam*(2*qq_VR(j)/lam*dr+u(M-1,j)-u(M-1,j))/(R*dr);
                                     QR2 = rr*lam*(2*qq_VR(j)/lam*dr+u(M-1,j)-2*u(M,j)+u(M-1,j));
                                    QPHI = rphi(j)*R*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                                 hh(M,j) = h(M,j) +  QR1 + QR2 + QPHI  + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
% % % % % %
                              end
                              
                         else
                                htc_r(j) = (0.78828571429 + 0.0003375*(u(M,j)+273.15) - 40.17857143*10^(-8)*(u(M,j)+273.15)^2)*5.67051*10^(-8)*((u(M,j)+273.15)^2+(Tinf+273.15)^2)*((u(M,j)+273.15)+(Tinf+273.15));                  
                              if OP_VR(j,6)==0
                                
                                      QX = rx*lam*(2*(OP_VR(j,5)+htc_r(j))*dx*(Tw-u(M,j))/lam+u(M-1,j)-2*u(M,j)+u(M-1,j));
                                      QZ = ry(j)*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                                 hh(M,j) = h(M,j) +  QX + QZ  + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
                   
                              else
% % % % % %  

                                     QR1 = dt*lam*(2*(OP_VR(j,5)+htc_r(j))*dr*(Tw-u(M,j))/lam+u(M-1,j)-u(M-1,j))/(R*dr);
                                     QR2 = rr*lam*(2*(OP_VR(j,5)+htc_r(j))*dr*(Tw-u(M,j))/lam+u(M-1,j)-2*u(M,j)+u(M-1,j));
                                    QPHI = rphi(j)*R*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j)) ;
                                 hh(M,j) = h(M,j) + QR1 + QR2 + QPHI + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
% % % % % %
                              end
                              
                         end
             
               else 
                htc_nat(j) = 0.84*(u(M,j)-Tinf)^0.5;
                  htc_r(j) = (0.78828571429 + 0.0003375*(u(M,j)+273.15) - 40.17857143*10^(-8)*(u(M,j)+273.15)^2)*5.67051*10^(-8)*((u(M,j)+273.15)^2+(Tinf+273.15)^2)*((u(M,j)+273.15)+(Tinf+273.15));                  
                        QX = rx*lam*(2*(htc_nat(j)+htc_r(j))*dx*(Tinf-u(M,j))/lam+u(M-1,j)-2*u(M,j)+u(M-1,j));
                        QZ = ry(j)*lam*((u(M,j-1)-u(M,j))/dz(j-1)+(u(M,j+1)-u(M,j))/dz(j));
                   hh(M,j) = h(M,j) +  QX + QZ  + V*dt*(h(M,j-1)-h(M,j))/dz(j-1);
               end
%     STRANA CHLAZENI ZPO MR     
              lam = lambda(round(u(1,j)));
               if OP_MR(j,2)==1  
                   if OP_MR(j,6)==0 
                                QX = rx*lam*(2*qo/lam*dx+u(2,j)-2*u(1,j)+u(2,j));
                                QZ = ry(j)*lam*((u(1,j-1)-u(1,j))/dz(j-1)+(u(1,j+1)-u(1,j))/dz(j));
                           hh(1,j) = h(1,j) + QX + QZ + V*dt*(h(1,j-1)-h(1,j))/dz(j-1);
% % % %  
                   else
                               QR1 = dt*lam*(2*qo/lam*dr+u(2,j)-u(2,j))/((R-L)*dr);
                               QR2 = rr*lam*(2*qo/lam*dr+u(2,j)-2*u(1,j)+u(2,j));
                              QPHI = rphi(j)*(R-L)*lam*((u(1,j-1)-u(1,j))/(dz(j-1)*(R-L)/R)+(u(1,j+1)-u(1,j))/(dz(j)*(R-L)/R));
                           hh(1,j) = h(1,j) +  QR1 + QR2 + QPHI  + V*dt*(h(1,j-1)-h(1,j))/(dz(j-1)*(R-L)/R);
% % % % % % 
                   end
                   
               elseif OP_MR(j,2)==2 
                      
                         if OP_MR(j,3)==0  
                              if OP_MR(j,6)==0      
                                      QX = rx*lam*(2*qq_MR(j)/lam*dx+u(2,j)-2*u(1,j)+u(2,j));
                                      QZ = ry(j)*lam*((u(1,j-1)-u(1,j))/dz(j-1)+(u(1,j+1)-u(1,j))/dz(j));
                                 hh(1,j) = h(1,j) + QX + QZ  + V*dt*(h(1,j-1)-h(1,j))/dz(j-1);
                              else
% % % % % %
                                     QR1 = dt*lam*(2*qq_MR(j)/lam*dr+u(2,j)-u(2,j))/((R-L)*dr);
                                     QR2 = rr*lam*(2*qq_MR(j)/lam*dr+u(2,j)-2*u(1,j)+u(2,j));
                                    QPHI = rphi(j)*(R-L)*lam*((u(1,j-1)-u(1,j))/(dz(j-1)*(R-L)/R)+(u(1,j+1)-u(1,j))/(dz(j)*(R-L)/R));
                                 hh(1,j) = h(1,j) +  QR1 + QR2 + QPHI + V*dt*(h(1,j-1)-h(1,j))/(dz(j-1)*(R-L)/R);
% % % % % %
                              end
                              
                         else    
                                htc_r(j) = (0.78828571429 + 0.0003375*(u(1,j)+273.15) - 40.17857143*10^(-8)*(u(1,j)+273.15)^2)*5.67051*10^(-8)*((u(1,j)+273.15)^2+(Tinf+273.15)^2)*((u(1,j)+273.15)+(Tinf+273.15));                  
                             
                              if OP_MR(j,6)==0   
                                      QX = rx*lam*(2*(OP_MR(j,5)+htc_r(j))*dx*(Tw-u(1,j))/lam+u(2,j)-2*u(1,j)+u(2,j));
                                      QZ = ry(j)*lam*((u(1,j-1)-u(1,j))/dz(j-1)+(u(1,j+1)-u(1,j))/dz(j));
                                 hh(1,j) = h(1,j) +  QX + QZ + V*dt*(h(1,j-1)-h(1,j))/dz(j-1);
                   
                              else
% % % % % %  
                                     QR1 = dt*lam*(2*(OP_MR(j,5)+htc_r(j))*dr*(Tw-u(1,j))/lam+u(2,j)-u(2,j))/((R-L)*dr);
                                     QR2 = rr*lam*(2*(OP_MR(j,5)+htc_r(j))*dr*(Tw-u(1,j))/lam+u(2,j)-2*u(1,j)+u(2,j));
                                    QPHI = rphi(j)*(R-L)*lam*((u(1,j-1)-u(1,j))/(dz(j-1)*(R-L)/R)+(u(1,j+1)-u(1,j))/(dz(j)*(R-L)/R));
                                 hh(1,j) = h(1,j) +  QR1 + QR2 + QPHI  + V*dt*(h(1,j-1)-h(1,j))/(dz(j-1)*(R-L)/R);
% % % % % %
                              end
                              
                         end
             
               else 
                htc_nat(j) = 0.84*(u(1,j)-Tinf)^0.5;
                  htc_r(j) = (0.78828571429 + 0.0003375*(u(1,j)+273.15) - 40.17857143*10^(-8)*(u(1,j)+273.15)^2)*5.67051*10^(-8)*((u(1,j)+273.15)^2+(Tinf+273.15)^2)*((u(1,j)+273.15)+(Tinf+273.15));                  
                        QX = rx*lam*(2*(htc_nat(j)+htc_r(j))*dx*(Tinf-u(1,j))/lam+u(2,j)-2*u(1,j)+u(2,j));
                        QZ = ry(j)*lam*((u(1,j-1)-u(1,j))/dz(j-1)+(u(1,j+1)-u(1,j))/dz(j));
                   hh(1,j) = h(1,j) +  QX + QZ + V*dt*(h(1,j-1)-h(1,j))/dz(j-1);
               end      
              
          end
%     HLEDANI TEPLOT 
               uu = hledani_matrix(H,a,b,hh);

%     zastaven vpotu pi ustalenm stavu
          FF=abs((u(:,:))-(uu(:,:)));  %zmena???
             if sum(FF(:,:))<0.01;
                h = hh;    
                u = uu;
                 set(handles.time_text,'string', k);
                 stopBar= progressbar(T/T,2);
                break
             end

         h = hh;    
         u = uu;   
     
     
     
    
      if get(handles.popupmenu_graph,'Value') ==1
            if k == 1
           axes(handles.axes1)
           [X,Z] = meshgrid(xx,zz1);
              X1 = X-2;
              Z1 = -Z/4+0.36/4;  
           contourf(X1,Z1,uu(:,1:10)');hold on
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           [X,Z] = meshgrid(xx,zz2);
              r0 = (8)/4-L;
             fii = (2*pi/((max(zz2))*4))*Z;
              X1 = -cos(fii).*((r0+1*X));
              Z1 = -sin(fii).*((r0+1*X));
           contourf(X1,Z1,uu(:,10:116)');
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           [Z,X] = meshgrid(xx,zz3);
              X1 = X/4;
              Z1 = -Z-1.75;
           contourf(X1,Z1,uu(:,116:N)');hold off 
                  view(0, -270);  
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           set(gca,'XTickLabel',-2*4:0.5*4:3*4)  
           set(gca,'YTickLabel',-2*4:0.5*4:0.5*4)  
 %          axis equal 
           title('Temperature field'); 
       end
       if mod(k,100) == 0
           axes(handles.axes1)
           [X,Z] = meshgrid(xx,zz1);
              X1 = X-2;
              Z1 = -Z/4+0.36/4;  
           contourf(X1,Z1,uu(:,1:10)');hold on
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           [X,Z] = meshgrid(xx,zz2);
              r0 = (8)/4-L;
             fii = (2*pi/((max(zz2))*4))*Z;
              X1 = -cos(fii).*((r0+1*X));
              Z1 = -sin(fii).*((r0+1*X));
           contourf(X1,Z1,uu(:,10:116)');
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           [Z,X] = meshgrid(xx,zz3);
              X1 = X/4;
              Z1 = -Z-1.75;
           contourf(X1,Z1,uu(:,116:N)');hold off 
                  view(0, -270);  
         axis([-2.05 2.7 -2.1 0.3 0 1550]);
           set(gca,'XTickLabel',-2*4:0.5*4:3*4)  
           set(gca,'YTickLabel',-2*4:0.5*4:0.5*4)  
 %          axis equal 
           title('Temperature field'); 
       end
      else 
         if k == 1
            axes(handles.axes2)
            plot(zzz,uu(1,:),'b','LineWidth',2);hold on
            plot(zz,uu(end,:),'g','LineWidth',2);
            plot(zzzz,uu(round(M/2),:),'r','LineWidth',2);
            axis([0 (24) 0 1650]);
            title('Surface and core temperatures');
          hold off   
         end

          if mod(k,100) == 0
            axes(handles.axes2)
            plot(zzz,uu(1,:),'b','LineWidth',2);hold on
            plot(zz,uu(end,:),'g','LineWidth',2);
            plot(zzzz,uu(round(M/2),:),'r','LineWidth',2);
            axis([0 (24) 0 1650]);
            title('Surface and core temperatures');
          hold off   
         end
      end

set(handles.time_text,'string', k);
     drawnow
     stopBar= progressbar(k/T,4);
     if (stopBar) break; end


     end
      
%--------------------------------------------------------------------------
%Uloen dat
     v=uu(:,:);
     save('ZPO2Du.dat','v','-tabs','-ascii','-double')
     w=hh(:,:);
     save('ZPO2Dh.dat','w','-tabs','-ascii','-double')  
%--------------------------------------------------------------------------
%Vpis vslednho teplotnho pole a metalurgick dlky
    uu(:,:);
    Md = uu(round(M/2),:);
    global met
    global TS
    for j=1:N
           if TS >= Md(j)
               met=(zzzz(j)) ;   
           break
           else
               met=0;
           end
    end
%--------------------------------------------------------------------------




