Sets
	i  / 1, 2, 3 /  
        j  / 1, 2, 3, 4, 5, 6 /
        p  / 1, 2, 3 /  ; 

Parameters
        xi(p)
          / 1   @00 
            2   @01 
            3   @02  /

        wx(i)
          / 1   @100
            2   @101 
            3   @102  /

        xhat(i)
          / 1   @200 
            2   @201 
            3   @202  /

        wy(j)
          / 1   @103 
            2   @104 
            3   @105 
            4   @106 
            5   @107 
            6   @108  /

        yhat(j)
          / 1   @203 
            2   @204 
            3   @205 
            4   @206 
            5   @207 
            6   @208  /

        rho
          / @300 /  ;

Positive variables
	x(i)
        y(j)  ;

Variables
        z 	ucelova fce  ;

Equations
	objfunction
	podmA
        podmB  
        podmC
        podmD
        podmE  ;

	objfunction .. z =e= 150 * x('1') + 230 * x('2') + 260 * x('3') + 238 * y('2') + 210 * y('4') - 170 * y('1') - 
				150 * y('3') - 36 * y('5') - 10 * y('6')
	                             + sum(i, x(i) * wx(i)) + 0.5 * rho * sum(i, (x(i) - xhat(i)) * (x(i) - xhat(i))) ;
*                             + sum(j, y(j) * wy(j)) + 0.5 * rho * sum(j, (y(j) - yhat(j)) * (y(j) - yhat(j)))  ;

        podmA .. sum(i, x(i)) =l= 500 ; 
	podmB .. xi('1') * x('1') + y('2') - y('1') =g= 200  ;
        podmC .. xi('2') * x('2') + y('4') - y('3') =g= 240  ;
        podmD .. y('5') + y('6') =l= xi('3') * x('3')  ;
        podmE .. y('5') =l= 6000  ;

Model uloha /all/ ;

solve uloha using nlp minimizing z;

file done / done@400 /;
put done;
put 'finish';
